/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.utils.uicontrols.security;

import filenet.vw.api.VWException;
import filenet.vw.api.VWSession;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.utils.VWHelp;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.dialog.VWModalDialog;
import filenet.vw.toolkit.utils.resources.VWResource;
import filenet.vw.toolkit.utils.table.VWParticipantItem;
import filenet.vw.toolkit.utils.uicontrols.security.IVWParticipantSelectionDialog;
import filenet.vw.toolkit.utils.uicontrols.security.VWFilteredUsersAndGroupsPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class VWFilteredUsersAndGroupsDialog
extends VWModalDialog
implements IVWParticipantSelectionDialog,
ActionListener {
    public static final int OK = 1;
    public static final int CANCEL = 2;
    private JLabel m_wflGroupName = null;
    private JButton m_okButton = null;
    private JButton m_cancelButton = null;
    private JButton m_helpButton = null;
    protected VWFilteredUsersAndGroupsPanel m_usersGroupsPanel = null;
    protected int m_nStatus = 2;
    protected Frame m_parentFrame = null;
    protected VWSession m_vwSession = null;

    public VWFilteredUsersAndGroupsDialog(Frame parentFrame, VWSession vwSession) {
        super(parentFrame);
        this.m_parentFrame = parentFrame;
        this.m_vwSession = vwSession;
        this.layoutControls();
    }

    public VWFilteredUsersAndGroupsDialog(Dialog parent, VWSession vwSession) {
        super(parent);
        this.m_vwSession = vwSession;
        this.layoutControls();
    }

    public void init(VWParticipantItem[] vwParticipantItems, VWParticipantItem[] wflGroupList) throws VWException {
        throw new VWException("filenet.vw.toolkit.utils.uicontrols.security.invalidMethod", "Invalid method!");
    }

    public void init(VWParticipantItem[] vwParticipantItems, String wflGroupName) throws VWException {
        if (this.m_wflGroupName != null) {
            this.m_wflGroupName.setText(wflGroupName);
        }
        if (this.m_usersGroupsPanel != null) {
            this.m_usersGroupsPanel.init(vwParticipantItems);
        }
        this.m_nStatus = 2;
    }

    public VWParticipantItem[] getParticipants() {
        if (this.m_usersGroupsPanel != null) {
            return this.m_usersGroupsPanel.getParticipants();
        }
        return null;
    }

    public int getStatus() {
        return this.m_nStatus;
    }

    public void releaseReferences() {
        if (this.m_usersGroupsPanel != null) {
            this.m_usersGroupsPanel.removeReferences();
            this.m_usersGroupsPanel = null;
        }
    }

    public void actionPerformed(ActionEvent event) {
        if (event.getSource() == this.m_okButton) {
            this.m_nStatus = 1;
            this.setVisible(false);
        } else if (event.getSource() == this.m_cancelButton) {
            this.setVisible(false);
        } else if (event.getSource() == this.m_helpButton) {
            VWHelp.displayPage(VWHelp.Help_General + "bpfwd055.htm");
        }
    }

    protected void initializeContentPane() {
        try {
            if (this.m_wflGroupName != null) {
                this.getContentPane().add((Component)this.createHeaderPanel(), "First");
            }
            this.m_usersGroupsPanel = new VWFilteredUsersAndGroupsPanel(this, this.m_vwSession);
            this.getContentPane().add((Component)this.m_usersGroupsPanel, "Center");
            this.getContentPane().add((Component)this.createButtonPanel(), "Last");
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    protected JPanel createButtonPanel() {
        try {
            JPanel buttonPanel = new JPanel(new GridBagLayout());
            GridBagConstraints gbCons = new GridBagConstraints();
            gbCons.anchor = 10;
            gbCons.fill = 0;
            gbCons.gridx = 0;
            gbCons.gridy = 0;
            gbCons.gridwidth = 1;
            gbCons.gridheight = 1;
            gbCons.weightx = 0.0;
            gbCons.weighty = 0.0;
            gbCons.insets = new Insets(6, 6, 6, 6);
            this.m_okButton = new JButton(VWResource.s_ok);
            this.m_okButton.setName("m_okButton_VWFilteredUsersAndGroupsDialog");
            this.m_okButton.addActionListener(this);
            buttonPanel.add((Component)this.m_okButton, gbCons);
            ++gbCons.gridx;
            this.m_cancelButton = new JButton(VWResource.s_cancel);
            this.m_cancelButton.setName("m_cancelButton_VWFilteredUsersAndGroupsDialog");
            this.m_cancelButton.addActionListener(this);
            buttonPanel.add((Component)this.m_cancelButton, gbCons);
            ++gbCons.gridx;
            this.m_helpButton = new JButton(VWResource.s_help);
            this.m_helpButton.setName("m_helpButton_VWFilteredUsersAndGroupsDialog");
            this.m_helpButton.addActionListener(this);
            buttonPanel.add((Component)this.m_helpButton, gbCons);
            return buttonPanel;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    private void layoutControls() {
        try {
            Dimension dim = VWStringUtils.stringToDimension("555,335");
            if (dim == null) {
                dim = new Dimension(500, 300);
            }
            this.setSize(dim);
            this.getContentPane().setLayout(new BorderLayout(6, 6));
            this.setTitle(VWResource.s_participantSelection);
            this.setVisible(false);
            this.initializeContentPane();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private JPanel createHeaderPanel() {
        try {
            JPanel headerPanel = new JPanel(new GridBagLayout());
            GridBagConstraints gbCons = new GridBagConstraints();
            gbCons.anchor = 21;
            gbCons.fill = 0;
            gbCons.gridx = 0;
            gbCons.gridy = 0;
            gbCons.gridwidth = 1;
            gbCons.gridheight = 1;
            gbCons.weightx = 0.0;
            gbCons.weighty = 0.0;
            gbCons.insets = new Insets(6, 6, 6, 6);
            headerPanel.add((Component)new JLabel(VWResource.s_workflowGroupName), gbCons);
            gbCons.fill = 2;
            ++gbCons.gridx;
            gbCons.gridwidth = 0;
            gbCons.weightx = 1.0;
            this.m_wflGroupName = new JLabel();
            headerPanel.add((Component)this.m_wflGroupName, gbCons);
            return headerPanel;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }
}

